Shader "!FullControl/Effects/Projector Multiply 2 Layers" 
{
    Properties 
    {
       _ShadowTex ("Cookie A", 2D) = "white" { TexGen ObjectLinear }
       _ShadowTexB ("Cookie B", 2D) = "white" { TexGen ObjectLinear }
       _ShadowMask ("Cookie Mask", 2D) = "white" { TexGen ObjectLinear }
       
       _SizeA ("Cookie A Size", Float) = 1
       _SizeB ("Cookie B Size", Float) = 1
       
       _Int ("Projector Intensity", Float) = 1
       _SpeedX ("Speed X", Float) = 2
       _SpeedY ("Speed Y", Float) = 1
       _Speed2 ("Speed Layer 2", Float) = 1
    }
 
    Subshader {
       Tags { "RenderType"="Transparent" "Queue"="Transparent+100" }
       Pass {
         ZWrite Off
         Offset -1, -1
         Fog { Mode Off }
         ColorMask RGB
         Blend DstColor Zero
 
         CGPROGRAM
         #pragma vertex vert
         #pragma fragment frag
         #pragma fragmentoption ARB_fog_exp2
         #pragma fragmentoption ARB_precision_hint_fastest
         #include "UnityCG.cginc"
 
         struct v2f 
         {
          float4 pos : SV_POSITION;
          float2 uv : TEXCOORD0;
          float2 uvMask : TEXCOORD1;
         };
 
         sampler2D _ShadowTexB;    
         float4 _ShadowTexB_ST;
         
         sampler2D _ShadowMask;
         float4 _ShadowMask_ST;   
         
         fixed _Int;
         float4x4 _Projector;
         fixed _SizeB;
         fixed _SpeedX;
         fixed _SpeedY;
         fixed _Speed2;
 
         v2f vert (appdata_tan v) 
         {
          v2f o;
          
          o.pos = mul (UNITY_MATRIX_MVP, v.vertex);
          o.uv = TRANSFORM_TEX (mul (_Projector, v.vertex).xy, _ShadowTexB);
          o.uvMask = TRANSFORM_TEX (mul (_Projector, v.vertex).xy, _ShadowMask);
          o.uv.x += _Time * _SpeedX * _Speed2;
	      o.uv.y += _Time * _SpeedY * _Speed2;
          
          return o;
         }
 
         fixed4 frag (v2f i) : COLOR 
         {
         	fixed4 col = (1,1,1,1);
         	fixed4 finalA = tex2D (_ShadowTexB, fmod (i.uv, 1 / _SizeB) * _SizeB);
          //  return tex2D (_ShadowTexB, fmod (i.uv, 1 / _SizeB) * _SizeB) * col;
          	finalA = lerp(finalA, col, tex2D(_ShadowMask, i.uvMask));
          	
          	
            return finalA;
         }
 
         ENDCG
       }
       
       Pass 
       {
         ZWrite Off
         Offset -1, -1
         Fog { Mode Off }
         ColorMask RGB
         Blend DstColor Zero
 
         CGPROGRAM
         #pragma vertex vert
         #pragma fragment frag
         #pragma fragmentoption ARB_fog_exp2
         #pragma fragmentoption ARB_precision_hint_fastest
         #include "UnityCG.cginc"
 
         struct v2f 
         {
          float4 pos : SV_POSITION;
          float2 uv : TEXCOORD0;
          float2 uvMask : TEXCOORD1;
         };
 
         sampler2D _ShadowTex;
         float4 _ShadowTex_ST;
         
         sampler2D _ShadowMask;
         float4 _ShadowMask_ST; 
         
         fixed _Int;
         float4x4 _Projector;
         fixed _SizeA;
         fixed _SpeedX;
         fixed _SpeedY;
 
         v2f vert (appdata_tan v) 
         {
          v2f o;
          
          o.pos = mul (UNITY_MATRIX_MVP, v.vertex);
          o.uv = TRANSFORM_TEX (mul (_Projector, v.vertex).xy, _ShadowTex);
          o.uvMask = TRANSFORM_TEX (mul (_Projector, v.vertex).xy, _ShadowMask);
          o.uv.x += _Time * _SpeedX;
          o.uv.y += _Time * _SpeedY;
          
          return o;
         }
 
         fixed4 frag (v2f i) : COLOR 
         {
       		fixed4 col = (1,1,1,1);
         	fixed4 finalB = tex2D (_ShadowTex, fmod (i.uv, 1 / _SizeA) * _SizeA);
          	finalB = lerp(finalB, col, tex2D(_ShadowMask, i.uvMask));
         	
         	//fixed4 col = (0,1,1,1);
            //return tex2D (_ShadowTex, fmod (i.uv, 1 / _SizeA) * _SizeA);
            return finalB;
         }
 
         ENDCG
       }
    }
}